<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsCourseBanner extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-course-banner';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Course Banner', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs About widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs About widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'course banner' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content_heading',
            [
                'label' => esc_html__( 'Course Banner', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'banner_image',
            [
                'label'   => esc_html__( 'Banner Image', 'bdevs-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
            ]
        ); 
        $this->add_control(
            'heading',
            [
                'label'       => __( 'Heading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
                'default'     => __( 'This is heading', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );  
        $this->add_control(
            'description',
            [
                'label'       => __( 'Description:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your description', 'bdevs-elementor' ),
                'default'     => __( 'This is description', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'icon_apply',
            [
                'label'   => esc_html__( 'Icon Apply', 'bdevs-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
            ]
        ); 
        $this->add_control(
            'link_apply',
            [
                'label'       => __( 'Link Apply Online:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter link apply online', 'bdevs-elementor' ),
                'default'     => __( '#' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'apply_button',
            [
                'label'       => __( 'Apply Online Button:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter apply online button', 'bdevs-elementor' ),
                'default'     => __( 'Apply Online' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'icon_download',
            [
                'label'       => __( 'Icon Download:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter icon download', 'bdevs-elementor' ),
                'default'     => __( 'icon-brochure-icon' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'link_download',
            [
                'label'       => __( 'Link Download:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter link download', 'bdevs-elementor' ),
                'default'     => __( '#' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'download_button',
            [
                'label'       => __( 'Download Button:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter download button', 'bdevs-elementor' ),
                'default'     => __( 'Download Prospects' ),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        /** 
        *   Layout section 
        **/
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );
        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        );
        $this->add_control(
            'show_heading',
            [
                'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );  

        $this->add_control(
            'show_description',
            [
                'label'   => esc_html__( 'Show Description', 'bdevs-elementor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();

    }

    public function render() {
    $settings  = $this->get_settings_for_display();
    extract($settings); ?>  
    <!-- Start Banner -->
    <div class="inner-banner" style="background-image:url(<?php echo wp_kses_post($settings['banner_image']['url']); ?>)">
        <div class="container">
            <div class="row">
                <div class="col-sm-8 col-lg-9">
                    <div class="content">
                        <?php if ( $settings['show_heading'] ) : ?>
                        <h1><?php print wp_kses_post($settings['heading']); ?></h1>
                        <?php endif; ?>
                        <?php if ( $settings['show_description'] ) : ?>
                        <p><?php print wp_kses_post($settings['description']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-sm-4 col-lg-3"> 
                    <?php if(isset($settings['link_apply']) && $settings['link_apply'] != ''){?>
                    <a href="<?php print wp_kses_post($settings['link_apply']); ?>" class="apply-online clearfix">
                        <div class="left clearfix"> 
                            <span class="icon">
                                <img src="<?php echo wp_kses_post($settings['icon_apply']['url']); ?>" class="img-responsive" alt="">
                            </span> 
                            <span class="txt"><?php print wp_kses_post($settings['apply_button']); ?></span> 
                        </div>
                        <div class="arrow"><i class="fa fa-angle-right" aria-hidden="true"></i></div>
                    </a> 
                    <?php } ?>
                    <?php if(isset($settings['link_download']) && $settings['link_download'] != ''){?>
                    <a href="<?php print wp_kses_post($settings['link_download']); ?>" class="download-prospects"><span class="<?php print wp_kses_post($settings['icon_download']); ?>"></span> <?php print wp_kses_post($settings['download_button']); ?></a> 
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <!-- End Banner --> 
    <?php
    }

}


