<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsGalleryFilter extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-gallery-filter';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Gallery Filter', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs About widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs About widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'gallery filter' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {
        
        $this->start_controls_section(
            'section_content_heading',
            [
                'label' => esc_html__( 'Gallery Filter', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'post_number',
            [
                'label'       => __( 'Posts Per Page:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your posts per page', 'bdevs-elementor' ),
                'default'     => __( '4', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'sortby',
            [
                'label'     => esc_html__( 'Sort', 'bdevs-elementor' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'sortby_style_1'  => esc_html__( 'Newest', 'bdevs-elementor' ),
                    'sortby_style_2'  => esc_html__( 'Oldest', 'bdevs-elementor' ),
                ],
                'default'   => 'sortby_style_1',
            ]
        );
        $this->end_controls_section();

        /** 
        *   Layout section 
        **/
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        );
        $this->end_controls_section();

    }

    public function render() {
        $settings  = $this->get_settings_for_display();
        extract($settings); 
        if ($settings['sortby']=='sortby_style_1') {
            $sortby = 'DESC';
        }
        if ($settings['sortby']=='sortby_style_2') {
            $sortby = 'ASC';
        }
        ?>
        <!-- Start Campus Tour -->
        <section class="campus-tour padding-lg">       
            <!-- gallery filter -->
            <div class="container text-center">
                <div class="isotopeFilters">
                    <ul class="gallery-filter clearfix">
                        <li class="active"><a href="#" data-filter="*"><?php echo esc_html__( 'All', 'edumart' );?></a></li>
                        <?php 
                            $types = get_terms('type1');   
                            foreach( (array)$types as $type){
                                $type_name = $type->name;
                                $type_slug = $type->slug;
                        ?>
                        <li><a href="#" data-filter=".<?php echo esc_attr($type_slug);?>"><?php echo esc_attr($type_name);?></a></li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
            <!-- end filter -->      
            <ul class="gallery clearfix isotopeContainer">
                <?php
                $post_number = $settings['post_number'];
                $wp_query = new \WP_Query(array('posts_per_page' => $post_number,'post_type' => 'gallery',  'orderby' => 'ID', 'order' => $sortby));     
                $args = new \WP_Query(array(   
                            'post_type' => 'gallery', 
                        ));  
                while ($wp_query -> have_posts()) : $wp_query -> the_post(); ?>
                <?php 
                $categs = get_the_terms(get_the_ID(),'category1');
                            $categ_name ='';
                            foreach((array)$categs as $categ){
                                $categ_name .= $categ->name.'  ' ;
                            }  
                $typs = get_the_terms(get_the_ID(),'type1');
                    $typ_slug = '';
                    foreach((array)$typs as $typ){
                        $typ_slug .= $typ->slug .' '; 
                    } 
                ?>
                <li class="isotopeSelector <?php echo esc_attr($typ_slug);?>">
                    <div class="overlay">
                        <h3><?php the_title(); ?></h3>
                        <p><?php echo esc_attr($categ_name);?></p>
                        <?php if ( has_post_thumbnail() ) { ?>
                        <a class="galleryItem" href="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>"><span class="icon-enlarge-icon"></span></a>
                        <?php } ?> 
                    </div>
                    <?php if ( has_post_thumbnail() ) { ?>
                    <figure>
                        <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" class="img-responsive" alt="">
                    </figure>
                    <?php } ?> 
                </li>
                <?php   
                endwhile; 
                wp_reset_postdata();
                ?>
            </ul>   
        </section>
        <!-- End Campus Tour -->       
    <?php
    }

}



