<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsGallery extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-gallery';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Gallery', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs About widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs About widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'gallery' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {
        
        $this->start_controls_section(
            'section_content_heading',
            [
                'label' => esc_html__( 'Gallery', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'chose_style',
            [
                'label'     => esc_html__( 'Chose Style', 'bdevs-elementor' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'g_style_1'  => esc_html__( 'Style 1', 'bdevs-elementor' ),
                    'g_style_2'  => esc_html__( 'Style 2', 'bdevs-elementor' ),
                ],
                'default'   => 'g_style_1',
            ]
        );
        $this->add_control(
            'subheading',
            [
                'label'       => __( 'Subheading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subheading', 'bdevs-elementor' ),
                'default'     => __( 'This is subheading', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        ); 
        $this->add_control(
            'heading',
            [
                'label'       => __( 'Heading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
                'default'     => __( 'This is heading', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        ); 
        $this->add_control(
            'post_number',
            [
                'label'       => __( 'Posts Per Page:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your posts per page', 'bdevs-elementor' ),
                'default'     => __( '10', 'bdevs-elementor' ),
                'label_block' => true,
                'condition' => [
                    'chose_style' => ['g_style_1']
                ],
            ]
        );
        $this->add_control(
            'sortby',
            [
                'label'     => esc_html__( 'Sort', 'bdevs-elementor' ),
                'type'      => Controls_Manager::SELECT,
                'condition' => [
                    'chose_style' => ['g_style_1']
                ],
                'options'   => [
                    'sortby_style_1'  => esc_html__( 'Newest', 'bdevs-elementor' ),
                    'sortby_style_2'  => esc_html__( 'Oldest', 'bdevs-elementor' ),
                ],
                'default'   => 'sortby_style_1',
            ]
        );
        $this->add_control(
            'tabs',
            [
                'label' => esc_html__( 'Images', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'condition' => [
                    'chose_style' => ['g_style_2']
                ],
                'fields' => [
                    [
                        'name'    => 'gallery_image',
                        'label'   => esc_html__( 'Image', 'bdevs-elementor' ),
                        'type'    => Controls_Manager::MEDIA,
                        'dynamic' => [ 'active' => true ],
                    ],
                    [
                        'name'        => 'title',
                        'label'       => esc_html__( 'Title:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is title' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'category_g',
                        'label'       => esc_html__( 'Category:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is category' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'link_gallery',
                        'label'       => esc_html__( 'Link To:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( '#' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        /** 
        *   Layout section 
        **/
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        );
        $this->add_control(
            'show_heading',
            [
                'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();

    }

    public function render() {
        $settings  = $this->get_settings_for_display();
        extract($settings); 
        if ($settings['sortby']=='sortby_style_1') {
            $sortby = 'DESC';
        }
        if ($settings['sortby']=='sortby_style_2') {
            $sortby = 'ASC';
        }
        ?>
        <?php $chose_style = $settings['chose_style'];?>
        <?php if( $chose_style == 'g_style_1' ): ?>
        <section class="campus-tour padding-lg">
            <div class="container">
                <?php if ( $settings['show_heading'] ) : ?>
                <h2>
                    <?php if(isset($settings['subheading']) && $settings['subheading'] != ''){?>
                    <span><?php print wp_kses_post($settings['subheading']); ?></span>
                    <?php } ?>
                    <?php print wp_kses_post($settings['heading']); ?> 
                </h2>
                <?php endif; ?>
            </div>
            <ul class="gallery clearfix">
                <?php
                $post_number = $settings['post_number'];
                $wp_query = new \WP_Query(array('posts_per_page' => $post_number,'post_type' => 'gallery',  'orderby' => 'ID', 'order' => $sortby));     
                $args = new \WP_Query(array(   
                            'post_type' => 'gallery', 
                        ));  
                while ($wp_query -> have_posts()) : $wp_query -> the_post(); ?>
                <?php 
                $categs = get_the_terms(get_the_ID(),'category1');
                    $categ_name ='';
                    foreach((array)$categs as $categ){
                        $categ_name .= $categ->name.'  ' ;
                    }  
                ?>
                <li>
                    <div class="overlay">
                        <h3><?php the_title(); ?></h3>
                        <p><?php echo esc_attr($categ_name);?></p>
                        <a class="galleryItem" href="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>"><span class="icon-enlarge-icon"></span></a> 
                    </div>
                    <figure><img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" class="img-responsive" alt=""></figure>
                </li>
                <?php   
                endwhile; 
                wp_reset_postdata();
                ?>
            </ul>
        </section>
        <!-- End Campus Tour Section -->  
        <?php elseif( $chose_style == 'g_style_2' ): ?>
        <!-- Start Campus Tour Section -->
        <section class="campus-tour padding-lg">
            <div class="container">
                <?php if ( $settings['show_heading'] ) : ?>
                <h2>
                    <?php if(isset($settings['subheading']) && $settings['subheading'] != ''){?>
                    <span><?php print wp_kses_post($settings['subheading']); ?></span>
                    <?php } ?>
                    <?php print wp_kses_post($settings['heading']); ?> 
                </h2>
                <?php endif; ?>
            </div>
            <ul class="gallery clearfix">
                <?php foreach ( $settings['tabs'] as $item ) : ?>
                <li>
                    <div class="overlay">
                        <?php if(isset($item['title']) && $item['title'] != ''){?>
                        <h3><?php print wp_kses_post($item['title']); ?></h3>
                        <?php } ?>
                        <?php if(isset($item['category_g']) && $item['category_g'] != ''){?>
                        <p><?php print wp_kses_post($item['category_g']); ?></p>
                        <?php } ?>
                        <a class="galleryItem" href="<?php echo wp_kses_post($item['gallery_image']['url']); ?>"><span class="icon-enlarge-icon"></span></a> 
                        <?php if(isset($item['link_gallery']) && $item['link_gallery'] != ''){?>
                        <a href="<?php print wp_kses_post($item['link_gallery']); ?>" class="more"><span class="icon-gallery-more-arrow"></span></a> 
                        <?php } ?>
                    </div>
                    <figure><img src="<?php echo wp_kses_post($item['gallery_image']['url']); ?>" class="img-responsive" alt=""></figure>
                </li>
                <?php endforeach; ?>
            </ul>
        </section>
        <!-- End Campus Tour Section -->     
        <?php endif; ?>   
    <?php
    }

}



